package jamezo97.clonecraft.network;

import jamezo97.clonecraft.entity.clone.EntityClone;

import java.util.Random;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetworkManager;
import net.minecraft.util.Vec3;
import cpw.mods.fml.relauncher.Side;

public class Handler14OnEatenFood extends Handler{
	
	@Value(id = 0)
	int entityId;
	
	@Value(id = 1)
	int slot;
	
	public Handler14OnEatenFood(int entityId, int slot){
		this.entityId = entityId;
		this.slot = slot;
	}
	
	public Handler14OnEatenFood(){
		
	}

	@Override
	public void handle(Side side, INetworkManager manager, EntityPlayer player) {
		if(side == Side.CLIENT){
			EntityClone clone = this.getCloneOnClient(entityId);
			if(clone != null){
				ItemStack food = clone.inventory.getStackInSlot(slot);
				if(food != null){
					spawnParticles(clone, food);
				}
			}
		}
	}
	
	public void spawnParticles(EntityClone clone, ItemStack par1ItemStack){
		Random rand = new Random();
		for (int j = 0; j < 15; ++j)
        {
            Vec3 vec3 = clone.worldObj.getWorldVec3Pool().getVecFromPool(((double)rand.nextFloat() - 0.5D) * 0.1D, Math.random() * 0.1D + 0.1D, 0.0D);
            vec3.rotateAroundX(-clone.rotationPitch * (float)Math.PI / 180.0F);
            vec3.rotateAroundY(-clone.rotationYaw * (float)Math.PI / 180.0F);
            Vec3 vec31 = clone.worldObj.getWorldVec3Pool().getVecFromPool(((double)rand.nextFloat() - 0.5D) * 0.3D, (double)(-rand.nextFloat()) * 0.6D - 0.3D, 0.6D);
            vec31.rotateAroundX(-clone.rotationPitch * (float)Math.PI / 180.0F);
            vec31.rotateAroundY(-clone.rotationYaw * (float)Math.PI / 180.0F);
            vec31 = vec31.addVector(clone.posX, clone.posY + (double)clone.getEyeHeight(), clone.posZ);
            clone.worldObj.spawnParticle("iconcrack_" + par1ItemStack.getItem().itemID, vec31.xCoord, vec31.yCoord, vec31.zCoord, vec3.xCoord, vec3.yCoord + 0.05D, vec3.zCoord);
        }

        clone.playSound("random.eat", 0.5F + 0.5F * (float)rand.nextInt(2), (rand.nextFloat() - rand.nextFloat()) * 0.2F + 1.0F);
    
	}
	
	
	

}
